
import sys
from zipfile import ZipFile
import struct, os, imghdr, re, string


def editRecipe(recipefile,infilename):
        directory = os.getcwd()
        outfilename = os.path.join(directory+'\\Temp',infilename+'.recipe')
        custom_recipe = False
        try:
                infile = open(infilename+'.recipe','r')
                custom_recipe = True        
        except:
                try:
                        infile_str = ZipFile(recipefile, 'r').read(infilename+'.recipe')
                except:
                        print "\nERROR: Cannot locate "+infilename+".recipe\n"
                        return        
        outfile = open(outfilename,'wb')
        recipe_header_name = os.path.join(directory+'\\Resources','recipe-header.py')
        news_prefix_name = os.path.join(directory+'\\Resources','news-prefix.py')
        postprocess_html_frag_name = os.path.join(directory+'\\Resources','postprocess-html-frag.py')
        postprocess_html_name = os.path.join(directory+'\\Resources','postprocess-html.py')
        recipe_header = open(recipe_header_name,'r')
        news_prefix = open(news_prefix_name,'r')
        postprocess_html_frag = open(postprocess_html_frag_name,'r')
        postprocess_html = open(postprocess_html_name,'r')
        if custom_recipe:
                infile_str = infile.read()
        recipe_header_str = recipe_header.read()
        news_prefix_str = news_prefix.read()
        postprocess_html_frag_str = postprocess_html_frag.read()
        postprocess_html_str = postprocess_html.read()
        
        pph_result = re.search(r'\s*def\s+postprocess_html[^(]*\([^)]*\)\s*:',infile_str,re.S|re.I)
        if pph_result:
                infile_str = re.sub(r'def\s+postprocess_html','def orig_postprocess_html',infile_str,re.S|re.I)
                pph_result = re.search(r'\s*def orig_postprocess_html[^(]*\([^)]*\)\s*:',infile_str,re.S|re.I)
                news_result = re.search(r'\s*class[^(]+\(basicnewsrecipe\)\s*:',infile_str,re.S|re.I)
                if (news_result==None):
                        print "Cannot find news recipe class"
                        return
                outfile_str = infile_str[:news_result.start()+1]+recipe_header_str+\
                              infile_str[news_result.start():news_result.end()+1]+news_prefix_str+\
                              infile_str[news_result.end():pph_result.start()+1]+postprocess_html_frag_str+\
                              infile_str[pph_result.end():]
        else:
                news_result = re.search(r'\s*class[^(]+\(basicnewsrecipe\)\s*:',infile_str,re.S|re.I)
                if (news_result==None):
                        print "Cannot find news recipe class"
                        return
                outfile_str = infile_str[:news_result.start()+1]+recipe_header_str+\
                              infile_str[news_result.start():news_result.end()+1]+news_prefix_str+\
                              postprocess_html_str+infile_str[news_result.end():]
        outfile.write(outfile_str)
        outfile.flush()
        outfile.close()
                

def main(argv=sys.argv):
	recipefile = os.getenv('BUILTIN_RECIPES')
	infilename = sys.argv[1]
	try:
		editRecipe(recipefile,infilename)
	except ValueError, e:
		print "Error: %s" % e
		return 1
	return 0

if __name__ == "__main__":
	sys.exit(main())
